/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * GroupConnectionsView.java
 *
 * Created on 20-jun-2012, 11:06:12
 */
package org.sunspotUI;

import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.sunspotworld.*;

/**
 *
 * @author Migue
 */
public class GroupConnectionsView extends javax.swing.JFrame {

    private SunSpotHostApplication sha;
    BluetoothDevicesView bdv;

    
    /** Creates new form GroupConnectionsView */
    public GroupConnectionsView() {
        initComponents();
        bdv = new BluetoothDevicesView();
    }

    GroupConnectionsView(SunSpotHostApplication sha) {
        initComponents();
        this.sha = sha;
        bdv = new BluetoothDevicesView();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        groupCombo = new javax.swing.JComboBox();
        removeGroupButton = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        RemoveAgentButton = new javax.swing.JButton();
        list1 = new java.awt.List();
        jPanel3 = new javax.swing.JPanel();
        AIPLabel = new javax.swing.JLabel();
        APortLabel = new javax.swing.JLabel();
        AndroidIP = new javax.swing.JLabel();
        AndroidPort = new javax.swing.JLabel();
        groupLabel = new javax.swing.JLabel();
        groupName = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        SSIPLabel = new javax.swing.JLabel();
        SSPortLabel = new javax.swing.JLabel();
        SSIP = new javax.swing.JLabel();
        SSPort = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        numBT = new javax.swing.JLabel();

        setTitle("Groups Connections");
        setResizable(false);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Groups"));

        groupCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                groupComboActionPerformed(evt);
            }
        });

        File fi = new File("");
        String sep = System.getProperty("file.separator");
        String p = fi.getAbsolutePath()+sep+"build"+sep+"org"+sep+"images"+sep+"Remove all.png";
        removeGroupButton.setIcon(new javax.swing.ImageIcon(p));
        removeGroupButton.setText("Unregister Group");
        removeGroupButton.setToolTipText("Unregister Group");
        removeGroupButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeGroupButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(groupCombo, 0, 278, Short.MAX_VALUE)
            .addComponent(removeGroupButton, javax.swing.GroupLayout.DEFAULT_SIZE, 278, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(groupCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(removeGroupButton)
                .addContainerGap(12, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Agents"));

        File f = new File("");
        String s = f.getAbsolutePath()+sep+"build"+sep+"org"+sep+"images"+sep+"Unregister agent.png";
        RemoveAgentButton.setIcon(new javax.swing.ImageIcon(s));
        RemoveAgentButton.setToolTipText("Unregister agent from group");
        RemoveAgentButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                RemoveAgentButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(list1, javax.swing.GroupLayout.PREFERRED_SIZE, 274, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(RemoveAgentButton, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(10, 10, 10))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(RemoveAgentButton, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(376, Short.MAX_VALUE))
            .addComponent(list1, javax.swing.GroupLayout.DEFAULT_SIZE, 421, Short.MAX_VALUE)
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Android MulticastConnection Information"));

        AIPLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        AIPLabel.setText("IPv4:");

        APortLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        APortLabel.setText("Port:");

        AndroidIP.setForeground(java.awt.SystemColor.textHighlight);

        AndroidPort.setForeground(java.awt.SystemColor.textHighlight);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(AIPLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(AndroidIP, javax.swing.GroupLayout.DEFAULT_SIZE, 223, Short.MAX_VALUE))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(APortLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(AndroidPort, javax.swing.GroupLayout.DEFAULT_SIZE, 225, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(AIPLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(AndroidIP, javax.swing.GroupLayout.PREFERRED_SIZE, 17, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(APortLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(AndroidPort, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        groupLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        groupLabel.setText("Group Name:");

        groupName.setForeground(java.awt.SystemColor.textHighlight);

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("SunSpot MulticastConnection Information"));

        SSIPLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        SSIPLabel.setText("IPv6:");

        SSPortLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        SSPortLabel.setText("Port:");

        SSIP.setForeground(java.awt.SystemColor.textHighlight);
        SSIP.setToolTipText("");

        SSPort.setForeground(java.awt.SystemColor.textHighlight);

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(SSIPLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SSIP, javax.swing.GroupLayout.DEFAULT_SIZE, 223, Short.MAX_VALUE))
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(SSPortLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SSPort, javax.swing.GroupLayout.DEFAULT_SIZE, 225, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(SSIPLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(SSIP, javax.swing.GroupLayout.PREFERRED_SIZE, 17, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(SSPortLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(SSPort, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder("Bluetooth Devices Information"));

        jButton1.setText("Bluetooth Devices");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel1.setText("Bluetoot Devices:");

        numBT.setForeground(new java.awt.Color(51, 153, 255));

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButton1, javax.swing.GroupLayout.DEFAULT_SIZE, 258, Short.MAX_VALUE)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(numBT, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(numBT, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 34, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(groupLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 72, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(groupName, javax.swing.GroupLayout.DEFAULT_SIZE, 202, Short.MAX_VALUE))
                            .addComponent(jPanel5, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel4, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(groupName, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(groupLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 22, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED, 37, Short.MAX_VALUE)
                        .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void groupComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_groupComboActionPerformed
        // TODO add your handling code here:
        String s = (String) groupCombo.getSelectedItem();
        if(s!=null){
            GroupConnection gc = (GroupConnection) sha.getConnection(s);
            Hashtable<Integer,SenderConnection> conn = gc.getConnections();
            SenderConnection sc;
            Integer t;
            for (Iterator it = conn.keySet().iterator(); it.hasNext();) {
                t = (Integer) it.next();
                sc = conn.get(t);
                if(t.equals(TypeConnection.TYPE_TCPMC)){
                    MulticastConnection mc = (MulticastConnection) sc;
                    AndroidIP.setText(mc.getIP());
                    AndroidPort.setText(Integer.valueOf(mc.getPort()).toString());
                }else if(t.equals(TypeConnection.TYPE_SSMC)){
                    SunSpotConnection ssc = (SunSpotConnection) sc;
                    SSIP.setText(ssc.getHOST());
                    SSPort.setText(Integer.valueOf(ssc.getPORT()).toString());
                }else if(t.equals(TypeConnection.TYPE_BTMC)){
                    BluetoothMulticast btm = (BluetoothMulticast) sc;
                    Integer i = Integer.valueOf(btm.sizeBT());
                    numBT.setText(i.toString());
                    bdv.addAgent(btm);
                }
            }
            groupName.setText(gc.getGroupName());
            list1.removeAll();
            List<String> agents = gc.getAgents();
            for (int i = 0; i < agents.size(); i++) {
                list1.add(agents.get(i));
            }
        }
    }//GEN-LAST:event_groupComboActionPerformed

    private void RemoveAgentButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_RemoveAgentButtonActionPerformed
        // TODO add your handling code here:
        if(list1.getSelectedIndex()>-1){
            String id = list1.getSelectedItem();
            sha.unregisterAgentGroupAux((String)groupCombo.getSelectedItem(),id);
            //updateAgents();
            this.updateGroups();
        }
    }//GEN-LAST:event_RemoveAgentButtonActionPerformed

    private void removeGroupButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeGroupButtonActionPerformed
        // TODO add your handling code here:
        if(groupCombo.getSelectedIndex()>-1){
            String groupName = (String) groupCombo.getSelectedItem();
            groupCombo.removeItem(groupName);
            sha.unregisterGroupConnectionAux(groupName);
            clearInfo();
            updateGroups();
        }
    }//GEN-LAST:event_removeGroupButtonActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
        bdv.setVisible(true);
    }//GEN-LAST:event_jButton1ActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(GroupConnectionsView.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(GroupConnectionsView.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(GroupConnectionsView.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(GroupConnectionsView.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new GroupConnectionsView().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel AIPLabel;
    private javax.swing.JLabel APortLabel;
    private javax.swing.JLabel AndroidIP;
    private javax.swing.JLabel AndroidPort;
    private javax.swing.JButton RemoveAgentButton;
    private javax.swing.JLabel SSIP;
    private javax.swing.JLabel SSIPLabel;
    private javax.swing.JLabel SSPort;
    private javax.swing.JLabel SSPortLabel;
    private javax.swing.JComboBox groupCombo;
    private javax.swing.JLabel groupLabel;
    private javax.swing.JLabel groupName;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private java.awt.List list1;
    private javax.swing.JLabel numBT;
    private javax.swing.JButton removeGroupButton;
    // End of variables declaration//GEN-END:variables

    void updateGroups() {
        groupCombo.removeAllItems();
        try{
            List<String> groups = sha.getIdGroups();
            for (int i = 0; i < groups.size(); i++) {
                groupCombo.addItem(groups.get(i));
            }
        }catch(Exception e){
            System.out.println(e.getLocalizedMessage());
        }
        updateAgents();
        
        /*try{
            groupCombo.setSelectedIndex(groupCombo.getItemCount()-1);
        }catch(Exception e){
            System.out.println(e.getLocalizedMessage());
        }*/
    }
    
    void updateGroups(List<String> groups) {
        groupCombo.removeAllItems();
        try{
            //List<String> groups = sha.getIdGroups();
            for (int i = 0; i < groups.size(); i++) {
                groupCombo.addItem(groups.get(i));
            }
        }catch(Exception e){
            System.out.println(e.getLocalizedMessage());
        }
        updateAgents();
        //groupCombo.setSelectedIndex(groupCombo.getItemCount()-1);
    }

    protected void updateAgents() {
        if(groupCombo.getSelectedIndex()>-1){
            String groupName = (String) groupCombo.getSelectedItem();
            GroupConnection gc = (GroupConnection) sha.getConnection(groupName);
            List<String> agents = gc.getAgents();
            list1.removeAll();
            for (int i = 0; i < agents.size(); i++) {
                list1.add(agents.get(i));
            }
        }else{
            list1.removeAll();
        }
    }

    private void clearInfo() {
            groupName.setText("");
            AndroidIP.setText("");
            AndroidPort.setText("");
            
            SSIP.setText("");
            SSPort.setText("");
            
            numBT.setText("");
    }
}
